library('deSolve')

# derivatives for the Lotka-Volterra predator-prey model
LV_derivatives = function(t,N,parms)
    {
    dN1dt = with(parms, r*N[1]-alpha*N[1]*N[2])
    dN2dt = with(parms, beta*N[1]*N[2]-m*N[2])
    return(list(c(dN1dt,dN2dt)))
    }

# specify parameter values
parms = list(r=2,alpha=0.2,beta=0.02,m=0.3)
N0 = c(5,10)
ts = seq(0,50,length.out=1000)

# run the differential equation solver to get time series
N_t = ode(N0,ts,LV_derivatives,parms)
plot(N_t) 
  
graphics.off()
plot(N_t[,2],N_t[,3],type='l') 
  
dN1dt = with(parms, r*N[1]*(1-N[1]/K)-alpha*(N[1]/(h+N[1]))*N[2])
dN2dt = with(parms, epsilon*alpha*N[2]*N[1]/(h+N[1])-m*N[2]) 
  
parms = list(r=0.5,alpha=2,epsilon=0.1,h=10,m=0.1,K=20)
N0 = c(6,0.5)
ts=seq(1,200,length.out=1000)
